#ifndef symbols_h
#define symbols_h

#include <stdio.h>

enum kstruct_offset {
  /* struct task */
  KSTRUCT_OFFSET_TASK_LCK_MTX_TYPE,
  KSTRUCT_OFFSET_TASK_REF_COUNT,
  KSTRUCT_OFFSET_TASK_ACTIVE,
  KSTRUCT_OFFSET_TASK_VM_MAP,
  KSTRUCT_OFFSET_TASK_NEXT,
  KSTRUCT_OFFSET_TASK_PREV,
  KSTRUCT_OFFSET_TASK_ITK_SPACE,
  KSTRUCT_OFFSET_TASK_BSD_INFO,
  
  /* struct ipc_port */
  KSTRUCT_OFFSET_IPC_PORT_IO_BITS,
  KSTRUCT_OFFSET_IPC_PORT_IO_REFERENCES,
  KSTRUCT_OFFSET_IPC_PORT_IKMQ_BASE,
  KSTRUCT_OFFSET_IPC_PORT_MSG_COUNT,
  KSTRUCT_OFFSET_IPC_PORT_IP_RECEIVER,
  KSTRUCT_OFFSET_IPC_PORT_IP_KOBJECT,
  KSTRUCT_OFFSET_IPC_PORT_IP_CONTEXT,
  KSTRUCT_OFFSET_IPC_PORT_IP_SRIGHTS,
  
  /* struct proc */
  KSTRUCT_OFFSET_PROC_PID,
  
  /* struct ipc_space */
  KSTRUCT_OFFSET_IPC_SPACE_IS_TABLE,
  
  /* struct thread */
  KSTRUCT_OFFSET_THREAD_BOUND_PROCESSOR,
  KSTRUCT_OFFSET_THREAD_LAST_PROCESSOR,
  KSTRUCT_OFFSET_THREAD_CHOSEN_PROCESSOR,
  KSTRUCT_OFFSET_THREAD_CONTEXT_DATA,     // thread.machine.contextData
  KSTRUCT_OFFSET_THREAD_UPCB,             // thread.machine.upcb
  KSTRUCT_OFFSET_THREAD_UNEON,            // thread.machine.uNeon
  KSTRUCT_OFFSET_THREAD_KSTACKPTR,
  
  /* struct processor */
  KSTRUCT_OFFSET_PROCESSOR_CPU_ID,
  
  /* struct cpu_data */
  KSTRUCT_OFFSET_CPU_DATA_EXCEPSTACKPTR,  // despite the name this actually points to the top of the stack, not the bottom
  KSTRUCT_OFFSET_CPU_DATA_CPU_PROCESSOR,
};



// the

enum ksymbol {
  KSYMBOL_OSARRAY_GET_META_CLASS,
  KSYMBOL_IOUSERCLIENT_GET_META_CLASS,
  KSYMBOL_IOUSERCLIENT_GET_TARGET_AND_TRAP_FOR_INDEX,
  KSYMBOL_CSBLOB_GET_CD_HASH,
  KSYMBOL_KALLOC_EXTERNAL,
  KSYMBOL_KFREE,
  KSYMBOL_RET,
  KSYMBOL_OSSERIALIZER_SERIALIZE,
  KSYMBOL_KPRINTF,
  KSYMBOL_UUID_COPY,
  KSYMBOL_CPU_DATA_ENTRIES,
  KSYMBOL_VALID_LINK_REGISTER,
  KSYMBOL_X21_JOP_GADGET,
  KSYMBOL_EXCEPTION_RETURN,
  KSYMBOL_THREAD_EXCEPTION_RETURN,
  KSYMBOL_SET_MDSCR_EL1_GADGET,
  KSYMBOL_WRITE_SYSCALL_ENTRYPOINT,
  KSYMBOL_EL1_HW_BP_INFINITE_LOOP,
  KSYMBOL_SLEH_SYNC_EPILOG
};

int koffset(enum kstruct_offset);

uint64_t ksym(enum ksymbol);

void offsets_init(void);
void symbols_init(void);
int probably_have_correct_symbols(void);

#endif
